/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public record MaterialStatsWrapper(Material material) {
    public List<ItemStack> getItemStacks() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return Collections.emptyList();
        }
        MaterialVariantId variantId = MaterialVariantId.parse((String)this.material.getIdentifier().toString());
        List<ItemStack> repairStacks = RecipeHelper.getUIRecipes((RecipeManager)world.m_7465_(), (RecipeType)((RecipeType)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class, recipe -> variantId.matchesVariant(recipe.getMaterial())).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_())).collect(Collectors.toList());
        if (repairStacks.isEmpty()) {
            repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(variantId));
        }
        return repairStacks;
    }

    public FluidStack getFluidStack() {
        return MaterialCastingLookup.getCastingFluids((MaterialVariantId)this.material.getIdentifier()).stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
    }

    public List<ItemStack> getToolParts() {
        return RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, (TagKey)TinkerTags.Items.TOOL_PARTS).filter(part -> part instanceof IToolPart).map(part -> (IToolPart)part).filter(part -> part.canUseMaterial((IMaterial)this.material)).map(part -> part.withMaterial((MaterialVariantId)this.material.getIdentifier())).collect(Collectors.toList());
    }

    public MaterialId getMaterialId() {
        return this.material.getIdentifier().getId();
    }

    public boolean hasTraits() {
        List<MaterialStatsId> stats = List.of(HeadMaterialStats.ID, ExtraMaterialStats.ID, HandleMaterialStats.ID, LimbMaterialStats.ID, GripMaterialStats.ID, BowstringMaterialStats.ID);
        return stats.stream().anyMatch(stat -> !this.getTraits((MaterialStatsId)stat).isEmpty());
    }

    public <T extends BaseMaterialStats> Optional<T> getStats(MaterialStatsId materialStatsId) {
        return MaterialRegistry.getInstance().getMaterialStats(this.getMaterialId(), materialStatsId);
    }

    public List<ModifierEntry> getTraits(MaterialStatsId materialStatsId) {
        return MaterialRegistry.getInstance().getTraits(this.material.getIdentifier().getId(), materialStatsId);
    }
}

